/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.testscenarios.executors;

import java.util.HashMap;
import java.util.Map;
import org.drools.ide.common.client.modeldriven.testing.CallFieldValue;
import org.drools.ide.common.client.modeldriven.testing.CallMethod;
import org.mvel2.MVEL;

public class MethodExecutor {
    private final Map<String, Object> populatedData;

    public MethodExecutor(Map<String, Object> populatedData) {
        this.populatedData = populatedData;
    }

    private String build(CallMethod callMethod, Map<String, Object> vars) {
        StringBuilder methodCallAsSting = new StringBuilder();
        methodCallAsSting.append("__fact__." + callMethod.getMethodName());
        methodCallAsSting.append("(");
        for (int i = 0; i < callMethod.getCallFieldValues().length; ++i) {
            CallFieldValue field = callMethod.getCallFieldValues()[i];
            if (!field.hasValue()) continue;
            String variableId = String.format("__val%d__", i);
            vars.put(variableId, this.getFieldValue(field));
            methodCallAsSting.append(variableId);
            if (!this.isThisTheLastVariable(callMethod, i)) continue;
            methodCallAsSting.append(",");
        }
        methodCallAsSting.append(")");
        return methodCallAsSting.toString();
    }

    private boolean isThisTheLastVariable(CallMethod callMethod, int i) {
        return i < callMethod.getCallFieldValues().length - 1;
    }

    private Object getFieldValue(CallFieldValue field) {
        Object val = this.isTheValueAPreviouslyDefinedObject(field) ? this.populatedData.get(field.value.substring(1)) : field.value;
        return val;
    }

    private boolean isTheValueAPreviouslyDefinedObject(CallFieldValue field) {
        return field.value.startsWith("=");
    }

    public Object executeMethod(CallMethod callMethod) {
        Map<String, Object> vars = this.initVars(callMethod);
        MVEL.eval(this.build(callMethod, vars), vars);
        return this.populatedData.get(callMethod.getVariable());
    }

    private Map<String, Object> initVars(CallMethod callMethod) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("__fact__", this.populatedData.get(callMethod.getVariable()));
        return vars;
    }
}

